/*

Testprogramm zum Senden von Messwerten vom Raspberry PI zum Webserver

Das Senden erfolg mit HTTP POST

Josef Bernhardt

20.1.2020

Hardware Raspberry PI 4

Codeblocks fuer Raspbian

Beispiel Message

POST /heizung/sqlabfrage.php HTTP/1.0
Host: www.bernhardt.de
Connection: close
Content-Type: application/x-www-form-urlencoded;charset=UTF-8;
Content-Length: 44

aktion=write&file=inputs.csv&inhalt=23.00;1;0;1;0;1;0;1;1

*/
#include <stdio.h>      /* printf, sprintf */
#include <stdlib.h>     /* exit */
#include <unistd.h>     /* read, write, close */
#include <string.h>     /* memcpy, memset */
#include <sys/socket.h> /* socket, connect */
#include <netinet/in.h> /* struct sockaddr_in, struct sockaddr */
#include <netdb.h>      /* struct hostent, gethostbyname */

void error(const char *msg) { perror(msg); /*exit(0);}*/ }

char strresult[16] = {'0',';','0',';','0',';','0',';','0',';','0',';','0',';','0',0};


 //   int portno =        80;
 //   char *host =        "www.bernhardt.de";

char *msg_post = "POST /modbus/sqlabfrage.php HTTP/1.0\r\n";
char *msg_host = "Host: www.bernhardt.de\r\n";
char *msg_conn = "Connection: close\r\n";
char *msg_cont = "Content-Type: application/x-www-form-urlencoded;charset=UTF-8;\r\n";
char *msg_conl = "Content-Length: %d\r\n\r\n";

//char *msg_action = "aktion=write&file=messwerte.csv&inhalt=12.46\r\n";
char *msg_acti = "aktion=write&file=inputs.csv&inhalt=%.2f;";
//char *msg_acti_s = "aktion=read&file=LED1.csv";


// mit Content length
char msg_conl_r[128]={0};
// mit Zahlenwert
char msg_acti_r[128]={0};

char msg_send[512]={0};

// Float Wert
float temperatur = 22.55;

//char message[1024];
char response[1024];


// Daten vom PSOC landen hier
char usr_response[128]={0};

// Poststring aufbauen
void build_post_string(float value, char *str)
{
    // Post Speicher loeschen
    memset(&msg_send,0,512);
    // Messwert in aktion String
    sprintf(msg_acti_r,msg_acti,value);

    // Laenge vom Aktion String berechnen und einfuegen
    sprintf(msg_conl_r,"Content-Length: %d\r\n\r\n",strlen(msg_acti)+15);
    // Sendestring aufbauen
    strcat(msg_send,msg_post);
    strcat(msg_send,msg_host);
    strcat(msg_send,msg_conn);
    strcat(msg_send,msg_cont);
    strcat(msg_send,msg_conl_r);
    strcat(msg_send,msg_acti_r);
    //strcat(msg_send,";1;0;1;0;1;0;1;0");
    strcat(msg_send,str);
}


// Daten zum Server senden
void sendpostmsg()
{

    int portno =        80;
    char *host =        "www.bernhardt.de";

    struct hostent *server;
    struct sockaddr_in serv_addr;
    int sockfd, bytes, sent, received, total;

    /* create the socket */
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) error("ERROR opening socket");

    /* lookup the ip address */
    server = gethostbyname(host);
    if (server == NULL) error("ERROR, no such host");

    /* fill in the structure */
    memset(&serv_addr,0,sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(portno);
    memcpy(&serv_addr.sin_addr.s_addr,server->h_addr,server->h_length);

    /* connect the socket */
    if (connect(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0)
        error("ERROR connecting");
        /* send the request */
        total = strlen(msg_send);
        sent = 0;
        do {
            bytes = write(sockfd,msg_send+sent,total-sent);
            if (bytes < 0)
                error("ERROR writing message to socket");
            if (bytes == 0)
                break;
            sent+=bytes;
        } while (sent < total);

        sleep(0.020);

        /* receive the response */
        memset(response,0,sizeof(response));
        total = sizeof(response)-1;
        received = 0;
        do {
            bytes = read(sockfd,response+received,total-received);
            if (bytes < 0)
                error("ERROR reading response from socket");
            if (bytes == 0)
                break;
            received+=bytes;
        } while (received < total);

        if (received == total)
        error("ERROR storing complete response from socket");
    /* close the socket */
    close(sockfd);
}



int replacechar(char *str, char orig, char rep) {
    char *ix = str;
    int n = 0;
    while((ix = strchr(ix, orig)) != NULL) {
        *ix++ = rep;
        n++;
    }
    return n;
}


// Hauptprogramm
int main(int argc,char *argv[])
{

float x = 0;
    while(1)
    {
           //system("clear");
           //build_post_string("1.34;1;0;1;0;1;0;1;0");

            x=x+0.01;


            build_post_string(x,strresult);

           sendpostmsg();
           sleep(1.0);

            build_post_string(x,"0;1;0;1;0;1;0;1");

           sendpostmsg();

           sleep(1.0);

           //printf(response);
           printf(msg_send);
           printf("\r\n\r\n");

       //}
    }
    return 0;
}
